<?php
namespace VM\FinancialStatementsBundle\Services;

use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieInwestycjiDS;
use VM\FinancialStatementsBundle\Services\InterfaceFinancialStatements;

class FinansowanieInwestycji extends CommonMethods
{
    protected $rokPoczatkowy = 1;
    protected $liczbaLat = 1;
    protected $dokladnosc = 2;

    protected $Amortyzacja;
    protected $Finansowanie;
    protected $Kredyt;
    protected $Leasing;
    protected $Podsumowanie;

    /**
     * @var FinansowanieInwestycjiDS
     */
    protected $DataStructure;

    /**
     * Constructor
     */
    protected function __construct(FinansowanieInwestycjiDS $FinansowanieInwestycjiDS)
    {
        $this->DataStructure = $FinansowanieInwestycjiDS;
        $this->liczbaLat = $FinansowanieInwestycjiDS->liczbaLat;
        $this->rokPoczatkowy = $FinansowanieInwestycjiDS->rokPoczatkowy;
        $this->dokladnosc = $FinansowanieInwestycjiDS->iloscMiejscPoPrzecinku;

        $this->buildAmortyzacjaStructure();
        $this->buildFinansowanieStructure();
        $this->buildLeasingStructure();
        $this->buildKredytStructure();
        $this->buildPodsumowanieStructure();

        $this->evaluateAll();
    }

    public static function create(FinansowanieInwestycjiDS $FinansowanieInwestycjiDS)
    {
        if($FinansowanieInwestycjiDS->validate())
        {
            return new FinansowanieInwestycji($FinansowanieInwestycjiDS);
        }
        else
        {
            throw new \Exception('Dane wejściowe nie przeszły walidacji.');
        }
    }

    protected function buildAmortyzacjaStructure()
    {
        $amortyzacja = new \stdClass();
        $amortyzacja->naklady = $this->DataStructure->__get('naklady');
        $amortyzacja->procentAmortyzacji = $this->DataStructure->__get('procentAmortyzacji');
        $amortyzacja->wartoscPoczatkowaNaRok = array();
        $amortyzacja->wartoscPoczatkowaNaRok[$this->rokPoczatkowy] =
            $this->DataStructure->__get('czyKapitalWlasny')?
                $this->DataStructure->__get('naklady'):
                ($this->DataStructure->__get('czyKredyt') ?
                    $this->DataStructure->__get('naklady') * $this->DataStructure->__get('czyNaSrodkiTrwale')*$this->DataStructure->__get('czyKredyt'): 0);
        $amortyzacja->amortyzacjaNaRok = array();
        $amortyzacja->amortyzacjaNaRok[$this->rokPoczatkowy] = 0;
        $amortyzacja->wartoscKoncowaNaRok = array();
        $amortyzacja->wartoscKoncowaNaRok[$this->rokPoczatkowy] = $amortyzacja->wartoscPoczatkowaNaRok[$this->rokPoczatkowy] - $amortyzacja->amortyzacjaNaRok[$this->rokPoczatkowy];
        $this->Amortyzacja = $amortyzacja;
    }

    protected function buildFinansowanieStructure()
    {
        $finansowanie = new \stdClass();
        $finansowanie->kapitalWlasny = $this->DataStructure->__get('kapitalWlasny');
        $finansowanie->kapitalObcy = $this->DataStructure->__get('kapitalObcy');
        $finansowanie->czyKapitalWlasny = $this->DataStructure->__get('czyKapitalWlasny');
        $finansowanie->czyKredyt = $this->DataStructure->__get('czyKredyt');
        $finansowanie->czyLeasing = $this->DataStructure->__get('czyLeasing');
        $finansowanie->czyNaSrodkiTrwale = $this->DataStructure->__get('czyNaSrodkiTrwale');
        $this->Finansowanie = $finansowanie;
    }

    protected function buildLeasingStructure()
    {
        $leasing = new \stdClass();
        $leasing->oprocentowanieRoczne = $this->DataStructure->__get('oprocentowanieKredytuLubLeasingu');
        $leasing->oprocentowanieRoczneKwotaNaRok = array();
        $leasing->okres = $this->DataStructure->__get('okresKredytuLubLeasingu');
        $leasing->kapitalNaRok = array();
        $leasing->rataLeasingowaNaRok = array();
        $leasing->ostatniaWplata = $this->DataStructure->__get('ostatniaWplataLeasingu');
        $leasing->ostatniaWplataNaRok = array();
        $this->Leasing = $leasing;
    }

    protected function buildKredytStructure()
    {
        $kredyt = new \stdClass();
        $kredyt->oprocentowanieRoczne = $this->DataStructure->__get('oprocentowanieKredytuLubLeasingu');
        $kredyt->oprocentowanieRoczneKwotaNaRok = array();
        $kredyt->okres = $this->DataStructure->__get('okresKredytuLubLeasingu');
        $kredyt->kapitalZmianaNaRok = array();
        $kredyt->kapitalZmianaNaRok[$this->rokPoczatkowy] = $this->DataStructure->__get('kapitalObcy');
        $kredyt->stanKoncowyNaRok = array();
        $kredyt->stanKoncowyNaRok[$this->rokPoczatkowy] = $kredyt->kapitalZmianaNaRok[$this->rokPoczatkowy];
        $kredyt->rataNaRok = array();
        $this->Kredyt = $kredyt;
    }

    protected function buildPodsumowanieStructure()
    {
        $podsumowanie = new \stdClass();
        $podsumowanie->zmianaKapitaluObcegoNaRok = array();
        $podsumowanie->zmianaKapitaluObcegoNaRok[$this->rokPoczatkowy] = $this->DataStructure->__get('czyKredyt')? $this->DataStructure->__get('kapitalObcy'): 0;
        $podsumowanie->kosztyFinansoweNaRok = array();
        $podsumowanie->zmianaKapitaluWlasnego =
            $this->DataStructure->__get('czyLeasing')? 0:
            ($this->DataStructure->__get('czyKredyt')?
                $this->DataStructure->__get('naklady') - $this->DataStructure->__get('kapitalObcy'):
                $this->DataStructure->__get('naklady'));
        $this->Podsumowanie = $podsumowanie;
    }

    protected function evaluateAll()
    {
        $this->evaluateAmortyzacja();
        $this->evaluateLeasing();
        $this->evaluateKredyt();
        $this->evaluatePodsumowanie();
    }

    protected function evaluateAmortyzacja()
    {
        $a = $this->Amortyzacja; // skrótowiec
        $a->wartoscPoczatkowaNaRok[$this->rokPoczatkowy] = $this->Finansowanie->czyKapitalWlasny? $a->naklady: ($this->Finansowanie->czyKredyt? $a->naklady*$this->Finansowanie->czyNaSrodkiTrwale*$this->Finansowanie->czyKredyt: 0);
        $a->wartoscKoncowaNaRok[$this->rokPoczatkowy] = $a->wartoscPoczatkowaNaRok[$this->rokPoczatkowy] - $a->amortyzacjaNaRok[$this->rokPoczatkowy];
        $a->amortyzacjaNaRok[$this->rokPoczatkowy] = 0;
        $a->wartoscPoczatkowaNaRok[$this->rokPoczatkowy+1] = $a->wartoscKoncowaNaRok[$this->rokPoczatkowy];
        $a->amortyzacjaNaRok[$this->rokPoczatkowy+1] = $a->wartoscPoczatkowaNaRok[$this->rokPoczatkowy+1] * $a->procentAmortyzacji;
        $a->wartoscKoncowaNaRok[$this->rokPoczatkowy+1] = $a->wartoscPoczatkowaNaRok[$this->rokPoczatkowy+1] - $a->amortyzacjaNaRok[$this->rokPoczatkowy+1];

        for($i = $this->rokPoczatkowy+2; $i <= $this->rokPoczatkowy+$this->liczbaLat; $i++)
        {
            $a->wartoscPoczatkowaNaRok[$i] = $a->wartoscKoncowaNaRok[$i-1];
            $a->amortyzacjaNaRok[$i] = $a->wartoscPoczatkowaNaRok[$i] > $a->amortyzacjaNaRok[$i-1]? $a->amortyzacjaNaRok[$i-1]: $a->wartoscPoczatkowaNaRok[$i];
            $a->wartoscKoncowaNaRok[$i] = $a->wartoscPoczatkowaNaRok[$i] - $a->amortyzacjaNaRok[$i];
        }
    }

    protected function evaluateLeasing()
    {
        $l = $this->Leasing; // skrótowiec
        for($i = $this->rokPoczatkowy+1; $i <= $this->rokPoczatkowy+$this->liczbaLat; $i++)
        {
            $iteracja = $i - $this->rokPoczatkowy;
            $l->oprocentowanieRoczneKwotaNaRok[$i] = $l->okres >= $iteracja? $this->IPMT($l->oprocentowanieRoczne, $iteracja, $l->okres, $this->Amortyzacja->naklady - $l->ostatniaWplata): 0;
            $l->rataLeasingowaNaRok[$i] = $l->okres >= $iteracja? $this->PMT($l->oprocentowanieRoczne, $l->okres, $this->Amortyzacja->naklady - $l->ostatniaWplata): 0;

            $l->ostatniaWplataNaRok[$i] = $i == $l->okres? -$l->ostatniaWplata: 0;
            $l->kapitalNaRok[$i] = $l->rataLeasingowaNaRok[$i] - $l->oprocentowanieRoczneKwotaNaRok[$i];
        }
    }

    protected function evaluateKredyt()
    {
        $k = $this->Kredyt; // skrótowiec
        $k->kapitalZmianaNaRok[$this->rokPoczatkowy] = $this->Finansowanie->kapitalObcy;
        $k->stanKoncowyNaRok[$this->rokPoczatkowy] = $k->kapitalZmianaNaRok[$this->rokPoczatkowy];
        for($i = $this->rokPoczatkowy+1; $i <= $this->rokPoczatkowy+$this->liczbaLat; $i++)
        {

            $iteracja = $i - $this->rokPoczatkowy;
//            $k->oprocentowanieRoczneKwotaNaRok[$i] = $k->okres >= $iteracja? $this->IPMT($k->oprocentowanieRoczne, $iteracja, $k->okres, $k->kapitalZmianaNaRok[$this->rokPoczatkowy]): 0;
//            $k->rataNaRok[$i] = $k->okres >= $iteracja? $this->PMT($k->oprocentowanieRoczne, $k->okres, $k->kapitalZmianaNaRok[$this->rokPoczatkowy]): 0;

            $k->oprocentowanieRoczneKwotaNaRok[$i] = -($k->okres >= $iteracja? $k->stanKoncowyNaRok[$i-1] * $k->oprocentowanieRoczne: 0);
            $k->rataNaRok[$i] = -($k->okres >= $iteracja? $k->kapitalZmianaNaRok[$this->rokPoczatkowy]/$k->okres: 0);

            $k->kapitalZmianaNaRok[$i] = $k->rataNaRok[$i];
            $k->stanKoncowyNaRok[$i] = $i == $this->rokPoczatkowy+1? $k->stanKoncowyNaRok[$this->rokPoczatkowy] + $k->kapitalZmianaNaRok[$i]: $k->stanKoncowyNaRok[$i-1] + $k->kapitalZmianaNaRok[$i];
        }
    }

    protected function evaluatePodsumowanie()
    {
        $p = $this->Podsumowanie; // skrótowiec
        $p->zmianaKapitaluObcego = $this->Finansowanie->czyKredyt? $this->Finansowanie->kapitalObcy: 0;
        for($i = $this->rokPoczatkowy+1; $i <= $this->rokPoczatkowy+$this->liczbaLat; $i++)
        {
            $p->zmianaKapitaluObcegoNaRok[$i] = $this->Finansowanie->czyKredyt? $this->Kredyt->kapitalZmianaNaRok[$i]: 0;
            $p->kosztyFinansoweNaRok[$i] = $this->Finansowanie->czyKredyt? $this->Kredyt->oprocentowanieRoczneKwotaNaRok[$i]: ($this->Finansowanie->czyLeasing? $this->Leasing->rataLeasingowaNaRok[$i]: 0);
        }

        $p->zmianaKapitaluWlasnego = $this->Finansowanie->czyLeasing? 0: ($this->Finansowanie->czyKredyt? $this->Amortyzacja->naklady - $this->Kredyt->kapitalZmianaNaRok[$this->rokPoczatkowy]: $this->Amortyzacja->naklady);
    }

    public function getResultsOf($name)
    {
        return $this->$name;
    }

    public function getRokPoczatkowy()
    {
        return $this->rokPoczatkowy;
    }

    private function PMT($oprocentowanieRoczne, $liczbaLat, $kwotaDoSplaty, $kwotaKtoraMaZostacNaKoncu = 0, $typ = 0)
    {
        $pmt = $this->division($oprocentowanieRoczne, (pow(1+$oprocentowanieRoczne, $liczbaLat)-1)) * -($kwotaDoSplaty*pow(1+$oprocentowanieRoczne, $liczbaLat)+$kwotaKtoraMaZostacNaKoncu);
        $pmt = $typ == 1? $this->division($pmt, (1+$oprocentowanieRoczne)) : $pmt;
        return $pmt;
    }

    private function IPMT($oprocentowanieRoczne, $numerRaty, $liczbaLat, $kwotaDoSplaty, $kwotaKtoraMaZostacNaKoncu = 0, $typ = 0)
    {
        $ipmt = -($this->PMT($oprocentowanieRoczne, $liczbaLat, $kwotaDoSplaty) * $this->division((pow(1+$oprocentowanieRoczne, $numerRaty-1)-1), $oprocentowanieRoczne) + $kwotaDoSplaty*pow(1+$oprocentowanieRoczne, $numerRaty-1))*$oprocentowanieRoczne;
        $ipmt = $typ == 1? $this->division($ipmt, (1+$oprocentowanieRoczne)) : $ipmt;
        return $ipmt;
    }

}

?>
